/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaException;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.JobHandle;
import edu.iastate.cs.boa.LoginException;
import edu.iastate.cs.boa.NotLoggedInException;
import edu.iastate.cs.boa.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpTransportException;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransport;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoaClient
implements AutoCloseable {
    private static final String BOA_DOMAIN = "boa.cs.iastate.edu";
    private static final String BOA_PATH = "/boa/?q=boa/api";
    protected static final String METHOD_USER_LOGIN = "user.login";
    protected static final String METHOD_USER_LOGOUT = "user.logout";
    protected static final String METHOD_BOA_DATASETS = "boa.datasets";
    protected static final String METHOD_BOA_JOB = "boa.job";
    protected static final String METHOD_BOA_JOBS = "boa.jobs";
    protected static final String METHOD_BOA_JOBS_COUNT = "boa.count";
    protected static final String METHOD_BOA_JOBS_RANGE = "boa.range";
    protected static final String METHOD_BOA_SUBMIT = "boa.submit";
    protected static final String METHOD_JOB_STOP = "job.stop";
    protected static final String METHOD_JOB_RESUBMIT = "job.resubmit";
    protected static final String METHOD_JOB_DELETE = "job.delete";
    protected static final String METHOD_JOB_SET_PUBLIC = "job.setpublic";
    protected static final String METHOD_JOB_PUBLIC = "job.public";
    protected static final String METHOD_JOB_URL = "job.url";
    protected static final String METHOD_JOB_PUBLIC_URL = "job.publicurl";
    protected static final String METHOD_JOB_COMPILER_ERRORS = "job.compilerErrors";
    protected static final String METHOD_JOB_SOURCE = "job.source";
    protected static final String METHOD_JOB_OUTPUT = "job.output";
    protected final XmlRpcClient xmlRpcClient = new XmlRpcClient();
    protected boolean loggedIn = false;
    protected List<InputHandle> datasetCache = null;
    protected long datasetCacheTime = 0L;

    public BoaClient() {
        this(BOA_DOMAIN, BOA_PATH);
    }

    public BoaClient(String domain, String path) {
        if (domain.indexOf("/") != -1) {
            throw new IllegalArgumentException("Argument 'domain' should not contain the protocol (http://) or a path (/).");
        }
        if (path.indexOf("/") != 0) {
            throw new IllegalArgumentException("Argument 'path' should start with '/'.");
        }
        String endpointURL = "http://" + domain + path;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(endpointURL));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.xmlRpcClient.setConfig(config);
    }

    public void login(String username, String password) throws LoginException {
        this.loggedIn = false;
        try {
            Map response = (Map)this.xmlRpcClient.execute(METHOD_USER_LOGIN, new String[]{username, password});
            final String cookie = (String)response.get("session_name") + "=" + (String)response.get("sessid");
            final String token = (String)response.get("token");
            this.xmlRpcClient.setTransportFactory(new XmlRpcSunHttpTransportFactory(this.xmlRpcClient){

                public XmlRpcTransport getTransport() {
                    return new XmlRpcSunHttpTransport(BoaClient.this.xmlRpcClient){

                        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
                            super.initHttpHeaders(request);
                            this.setRequestHeader("Cookie", cookie);
                            this.setRequestHeader("X-CSRF-Token", token);
                        }
                    };
                }
            });
            this.loggedIn = true;
        }
        catch (XmlRpcHttpTransportException e) {
            throw new LoginException("Invalid path given to Boa API.", e);
        }
        catch (XmlRpcException e) {
            if (e.getMessage().indexOf("username") != -1) {
                throw new LoginException("Invalid username or password.", e);
            }
            if (e.getMessage().indexOf("response") != -1) {
                throw new LoginException("Invalid domain given to Boa API.", e);
            }
            if (e.getMessage().indexOf(":") != -1) {
                throw new LoginException(e.getMessage().substring(e.getMessage().indexOf(":") + 2), e);
            }
            throw new LoginException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws BoaException {
        this.resetDatasetCache();
        try {
            this.xmlRpcClient.execute(METHOD_USER_LOGOUT, new Object[0]);
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    protected void ensureLoggedIn() throws NotLoggedInException {
        if (!this.loggedIn) {
            throw new NotLoggedInException();
        }
    }

    public void resetDatasetCache() {
        this.datasetCache = null;
        this.datasetCacheTime = 0L;
    }

    public List<InputHandle> getDatasets() throws BoaException, NotLoggedInException {
        if (this.datasetCache != null && this.datasetCacheTime + 86400000L > System.currentTimeMillis()) {
            return this.datasetCache;
        }
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.xmlRpcClient.execute(METHOD_BOA_DATASETS, new Object[0]);
            this.datasetCache = new ArrayList<InputHandle>();
            for (int i = 0; i < result.length; ++i) {
                this.datasetCache.add(Util.parseDataset((Map)result[i]));
            }
            this.datasetCacheTime = System.currentTimeMillis();
            return this.datasetCache;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public String[] getDatasetNames() throws BoaException, NotLoggedInException {
        List<InputHandle> list = this.getDatasets();
        String[] items = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            items[i] = list.get(i).getName();
        }
        return items;
    }

    public InputHandle getDataset(String name) throws BoaException, NotLoggedInException {
        for (InputHandle h : this.getDatasets()) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public JobHandle getJob(int id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.xmlRpcClient.execute(METHOD_BOA_JOB, new Object[]{id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle getLastJob() throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        List<JobHandle> jobs = this.getJobList();
        if (jobs.isEmpty()) {
            return null;
        }
        return jobs.get(0);
    }

    public List<JobHandle> getJobList() throws BoaException, NotLoggedInException {
        return this.getJobList(false);
    }

    public List<JobHandle> getJobList(int offset, int length) throws BoaException, NotLoggedInException {
        return this.getJobList(false, offset, length);
    }

    public List<JobHandle> getJobList(boolean pub) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.xmlRpcClient.execute(METHOD_BOA_JOBS, new Object[]{pub});
            ArrayList<JobHandle> jobs = new ArrayList<JobHandle>();
            for (int i = 0; i < result.length; ++i) {
                jobs.add(Util.parseJob(this, (Map)result[i]));
            }
            return jobs;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public List<JobHandle> getJobList(boolean pub, int offset, int length) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.xmlRpcClient.execute(METHOD_BOA_JOBS_RANGE, new Object[]{pub, offset, length});
            ArrayList<JobHandle> jobs = new ArrayList<JobHandle>();
            for (int i = 0; i < result.length; ++i) {
                jobs.add(Util.parseJob(this, (Map)result[i]));
            }
            return jobs;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public int getJobCount() throws BoaException, NotLoggedInException {
        return this.getJobCount(false);
    }

    public int getJobCount(boolean pub) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Integer.parseInt((String)this.xmlRpcClient.execute(METHOD_BOA_JOBS_COUNT, new Object[]{pub}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle query(String query, InputHandle dataset) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.xmlRpcClient.execute(METHOD_BOA_SUBMIT, new Object[]{query, dataset.getId()}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle query(String query) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.xmlRpcClient.execute(METHOD_BOA_SUBMIT, new Object[]{query, this.getDatasets().get(0).getId()}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void stop(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.xmlRpcClient.execute(METHOD_JOB_STOP, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void resubmit(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.xmlRpcClient.execute(METHOD_JOB_RESUBMIT, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void delete(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.xmlRpcClient.execute(METHOD_JOB_DELETE, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void setPublic(long id, boolean isPublic) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.xmlRpcClient.execute(METHOD_JOB_SET_PUBLIC, new Object[]{"" + id, isPublic});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    boolean getPublic(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Integer.parseInt((String)this.xmlRpcClient.execute(METHOD_JOB_PUBLIC, new Object[]{"" + id})) > 0;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    URL getUrl(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return new URL((String)this.xmlRpcClient.execute(METHOD_JOB_URL, new Object[]{"" + id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    URL getPublicUrl(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return new URL((String)this.xmlRpcClient.execute(METHOD_JOB_PUBLIC_URL, new Object[]{"" + id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    List<String> getCompilerErrors(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.xmlRpcClient.execute(METHOD_JOB_COMPILER_ERRORS, new Object[]{"" + id});
            ArrayList<String> l = new ArrayList<String>();
            for (Object o : result) {
                l.add((String)o);
            }
            return l;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    String getSource(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return (String)this.xmlRpcClient.execute(METHOD_JOB_SOURCE, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    String getOutput(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return (String)this.xmlRpcClient.execute(METHOD_JOB_OUTPUT, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }
}

