/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaClient;
import edu.iastate.cs.boa.BoaException;
import edu.iastate.cs.boa.CompileStatus;
import edu.iastate.cs.boa.ExecutionStatus;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.NotLoggedInException;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobHandle
implements Serializable {
    private static final long serialVersionUID = 6601705556435705094L;
    private final BoaClient client;
    private final int id;
    private Date date;
    private final InputHandle dataset;
    private CompileStatus compilerStatus;
    private ExecutionStatus execStatus;

    public final int getId() {
        return this.id;
    }

    public final Date getDate() {
        return this.date;
    }

    public final InputHandle getDataset() {
        return this.dataset;
    }

    public final CompileStatus getCompilerStatus() {
        return this.compilerStatus;
    }

    public final ExecutionStatus getExecutionStatus() {
        return this.execStatus;
    }

    JobHandle(BoaClient client, int id, Date date, InputHandle dataset, CompileStatus compilerStatus, ExecutionStatus execStatus) {
        this.client = client;
        this.id = id;
        this.date = date;
        this.dataset = dataset;
        this.compilerStatus = compilerStatus;
        this.execStatus = execStatus;
    }

    public final String toString() {
        return this.id + " (" + this.date + ") - " + this.dataset + " - compiler_status(" + (Object)((Object)this.compilerStatus) + ") execution_status(" + (Object)((Object)this.execStatus) + ")";
    }

    public void stop() throws BoaException, NotLoggedInException {
        this.client.stop(this.id);
    }

    public void resubmit() throws BoaException, NotLoggedInException {
        this.client.resubmit(this.id);
    }

    public void delete() throws BoaException, NotLoggedInException {
        this.client.delete(this.id);
    }

    public void setPublic(boolean isPublic) throws BoaException, NotLoggedInException {
        this.client.setPublic(this.id, isPublic);
    }

    public boolean getPublic() throws BoaException, NotLoggedInException {
        return this.client.getPublic(this.id);
    }

    public URL getUrl() throws BoaException, NotLoggedInException {
        return this.client.getUrl(this.id);
    }

    public URL getPublicUrl() throws BoaException, NotLoggedInException {
        return this.client.getPublicUrl(this.id);
    }

    public List<String> getCompilerErrors() throws BoaException, NotLoggedInException {
        return this.client.getCompilerErrors(this.id);
    }

    public String getSource() throws BoaException, NotLoggedInException {
        return this.client.getSource(this.id);
    }

    public String getOutput() throws BoaException, NotLoggedInException {
        return this.client.getOutput(this.id);
    }

    public void refresh() throws BoaException, NotLoggedInException {
        JobHandle j = this.client.getJob(this.id);
        this.date = j.getDate();
        this.compilerStatus = j.getCompilerStatus();
        this.execStatus = j.getExecutionStatus();
    }
}

