/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaClient;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.JobHandle;

public class SampleClient {
    public static void main(String[] args) throws Exception {
        JobHandle j2;
        if (args.length != 2) {
            System.err.println("Error: wrong number of arguments");
            System.err.println("Use: SampleClient <username> <password>");
            System.exit(-1);
        }
        BoaClient client = new BoaClient();
        client.login(args[0], args[1]);
        System.out.println("logged in");
        for (InputHandle d : client.getDatasets()) {
            System.out.println(d);
        }
        System.out.println("number of jobs: " + client.getJobCount());
        System.out.println("number of public jobs: " + client.getJobCount(true));
        for (JobHandle j2 : client.getJobList(Math.max(10, client.getJobCount()) - 10, 10)) {
            System.out.println(j2);
        }
        JobHandle lastJob = client.getLastJob();
        System.out.println("Last job: " + lastJob);
        System.out.println("URL: " + lastJob.getUrl());
        System.out.println("Public URL: " + lastJob.getPublicUrl());
        System.out.println("Public? " + lastJob.getPublic());
        lastJob.setPublic(!lastJob.getPublic());
        System.out.println("Public? " + lastJob.getPublic());
        lastJob.setPublic(!lastJob.getPublic());
        System.out.println("Source:");
        System.out.println("---------------------");
        System.out.println(lastJob.getSource());
        System.out.println("---------------------");
        for (String err : lastJob.getCompilerErrors()) {
            System.out.println("Compile error: " + err);
        }
        System.out.println("Output:");
        System.out.println("---------------------");
        System.out.println(lastJob.getOutput());
        System.out.println("---------------------");
        j2 = client.query("o: output sum of int;\no << 1;");
        System.out.println("Submitted: " + j2);
        j2.stop();
        System.out.println("Stopped job: " + j2);
        j2.delete();
        System.out.println("Deleted job: " + j2);
        client.close();
        System.out.println("logged out");
    }
}

