/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaClient;
import edu.iastate.cs.boa.BoaException;
import edu.iastate.cs.boa.CompileStatus;
import edu.iastate.cs.boa.ExecutionStatus;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.NotLoggedInException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobHandle
implements Serializable {
    private static final long serialVersionUID = 6601705556435705094L;
    private final BoaClient client;
    private final int id;
    private Date date;
    private final InputHandle dataset;
    private CompileStatus compilerStatus;
    private ExecutionStatus execStatus;

    public final int getId() {
        return this.id;
    }

    public final Date getDate() {
        return this.date;
    }

    public final InputHandle getDataset() {
        return this.dataset;
    }

    public final CompileStatus getCompilerStatus() {
        return this.compilerStatus;
    }

    public final ExecutionStatus getExecutionStatus() {
        return this.execStatus;
    }

    JobHandle(BoaClient client, int id, Date date, InputHandle dataset, CompileStatus compilerStatus, ExecutionStatus execStatus) {
        this.client = client;
        this.id = id;
        this.date = date;
        this.dataset = dataset;
        this.compilerStatus = compilerStatus;
        this.execStatus = execStatus;
    }

    public final String toString() {
        return this.id + " (" + this.date + ") - " + this.dataset + " - compiler_status(" + (Object)((Object)this.compilerStatus) + ") execution_status(" + (Object)((Object)this.execStatus) + ")";
    }

    public void stop() throws BoaException, NotLoggedInException {
        this.client.stop(this.id);
    }

    public void resubmit() throws BoaException, NotLoggedInException {
        this.client.resubmit(this.id);
    }

    public void delete() throws BoaException, NotLoggedInException {
        this.client.delete(this.id);
    }

    public void setPublic(boolean isPublic) throws BoaException, NotLoggedInException {
        this.client.setPublic(this.id, isPublic);
    }

    public boolean getPublic() throws BoaException, NotLoggedInException {
        return this.client.getPublic(this.id);
    }

    public URL getUrl() throws BoaException, NotLoggedInException {
        return this.client.getUrl(this.id);
    }

    public URL getPublicUrl() throws BoaException, NotLoggedInException {
        return this.client.getPublicUrl(this.id);
    }

    public List<String> getCompilerErrors() throws BoaException, NotLoggedInException {
        return this.client.getCompilerErrors(this.id);
    }

    public String getSource() throws BoaException, NotLoggedInException {
        return this.client.getSource(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutput() throws BoaException, NotLoggedInException {
        File f = new File(UUID.randomUUID().toString());
        this.getOutput(f);
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            char[] buf = new char[4096];
            int len = 0;
            while ((len = br.read(buf, 0, 4096)) > 0) {
                sb.append(buf, 0, len);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
        try {
            f.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        return sb.toString();
    }

    public void getOutput(File f) throws BoaException, NotLoggedInException {
        this.client.getOutput(this.id, f);
    }

    public String getOutput(long start, long len) throws BoaException, NotLoggedInException {
        return this.client.getOutput(this.id, start, len);
    }

    public int getOutputSize() throws BoaException, NotLoggedInException {
        return this.client.getOutputSize(this.id);
    }

    public void refresh() throws BoaException, NotLoggedInException {
        JobHandle j = this.client.getJob(this.id);
        this.date = j.getDate();
        this.compilerStatus = j.getCompilerStatus();
        this.execStatus = j.getExecutionStatus();
    }
}

