/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaClient;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.JobHandle;

public class SampleClient {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Error: wrong number of arguments");
            System.err.println("Use: SampleClient <username> <password>");
            System.exit(-1);
        }
        BoaClient client = new BoaClient();
        client.login(args[0], args[1]);
        System.out.println("logged in");
        for (InputHandle d : client.getDatasets()) {
            System.out.println(d);
        }
        System.out.println("number of jobs: " + client.getJobCount());
        System.out.println("number of public jobs: " + client.getJobCount(true));
        for (JobHandle j : client.getJobList(Math.max(10, client.getJobCount()) - 10, 10)) {
            System.out.println(j);
        }
        if (client.getJobCount() > 0) {
            JobHandle lastJob = client.getLastJob();
            System.out.println("Last job: " + lastJob);
            System.out.println("URL: " + lastJob.getUrl());
            System.out.println("Public URL: " + lastJob.getPublicUrl());
            System.out.println("Public? " + lastJob.getPublic());
            lastJob.setPublic(!lastJob.getPublic());
            System.out.println("Public? " + lastJob.getPublic());
            lastJob.setPublic(!lastJob.getPublic());
            System.out.println("Source:");
            System.out.println("---------------------");
            System.out.println(lastJob.getSource());
            System.out.println("---------------------");
            for (String err : lastJob.getCompilerErrors()) {
                System.out.println("Compile error: " + err);
            }
            int size = lastJob.getOutputSize();
            System.out.println("Output (" + size + " bytes):");
            System.out.println("---------------------");
            System.out.println(lastJob.getOutput());
            System.out.println("---------------------");
        }
        JobHandle j = client.query("o: output sum of int;\no << 1;");
        System.out.println("Submitted: " + j);
        j.stop();
        System.out.println("Stopped job: " + j);
        j.delete();
        System.out.println("Deleted job: " + j);
        client.close();
        System.out.println("logged out");
    }
}

