/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaException;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.JobHandle;
import edu.iastate.cs.boa.LoginException;
import edu.iastate.cs.boa.NotLoggedInException;
import edu.iastate.cs.boa.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpTransportException;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransport;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransport;

public class BoaClient
implements AutoCloseable {
    private static final String BOA_DOMAIN = "boa.cs.iastate.edu";
    private static final String BOA_PATH = "/boa/?q=boa/api";
    protected static final String METHOD_SYSTEM_CONNECT = "system.connect";
    protected static final String METHOD_USER_LOGIN = "user.login";
    protected static final String METHOD_USER_LOGOUT = "user.logout";
    protected static final String METHOD_USER_TOKEN = "user.token";
    protected static final String METHOD_BOA_DATASETS = "boa.datasets";
    protected static final String METHOD_BOA_JOB = "boa.job";
    protected static final String METHOD_BOA_JOBS = "boa.jobs";
    protected static final String METHOD_BOA_JOBS_COUNT = "boa.count";
    protected static final String METHOD_BOA_JOBS_RANGE = "boa.range";
    protected static final String METHOD_BOA_SUBMIT = "boa.submit";
    protected static final String METHOD_JOB_STOP = "job.stop";
    protected static final String METHOD_JOB_RESUBMIT = "job.resubmit";
    protected static final String METHOD_JOB_DELETE = "job.delete";
    protected static final String METHOD_JOB_SET_PUBLIC = "job.setpublic";
    protected static final String METHOD_JOB_PUBLIC = "job.public";
    protected static final String METHOD_JOB_URL = "job.url";
    protected static final String METHOD_JOB_PUBLIC_URL = "job.publicurl";
    protected static final String METHOD_JOB_COMPILER_ERRORS = "job.compilerErrors";
    protected static final String METHOD_JOB_SOURCE = "job.source";
    protected static final String METHOD_JOB_OUTPUT = "job.output";
    protected static final String METHOD_JOB_OUTPUT_SIZE = "job.outputsize";
    protected static final String METHOD_JOB_PAGED_OUTPUT = "job.pagedoutput";
    protected final XmlRpcClient xmlRpcClient = new XmlRpcClient();
    protected boolean loggedIn = false;
    protected List<InputHandle> datasetCache = null;
    protected long datasetCacheTime = 0L;

    public BoaClient() {
        this(BOA_DOMAIN, BOA_PATH);
    }

    public BoaClient(String domain, String path) {
        if (domain.indexOf("/") != -1) {
            throw new IllegalArgumentException("Argument 'domain' should not contain the protocol (https://) or a path (/).");
        }
        if (path.indexOf("/") != 0) {
            throw new IllegalArgumentException("Argument 'path' should start with '/'.");
        }
        String endpointURL = "https://" + domain + path;
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(endpointURL));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.xmlRpcClient.setConfig(config);
    }

    private Object execute(Class c, String cmd, Object[] args) throws BoaException, XmlRpcException {
        Object ret = this.execute(cmd, args);
        if (!c.isInstance(ret)) {
            throw new BoaException("unexpected/missing/invalid API result value '" + ret.toString() + "'");
        }
        return ret;
    }

    private Object execute(String cmd, Object[] args) throws XmlRpcException {
        return this.xmlRpcClient.execute(cmd, args);
    }

    public void login(String username, String password) throws LoginException {
        if (this.loggedIn) {
            return;
        }
        this.loggedIn = false;
        try {
            Map response = (Map)this.execute(Map.class, METHOD_USER_LOGIN, new String[]{username, password});
            final String cookie = (String)response.get("session_name") + "=" + (String)response.get("sessid");
            final String token = (String)response.get("token");
            this.xmlRpcClient.setTransportFactory(new XmlRpcSunHttpTransportFactory(this.xmlRpcClient){

                @Override
                public XmlRpcTransport getTransport() {
                    return new XmlRpcSunHttpTransport(BoaClient.this.xmlRpcClient){

                        @Override
                        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
                            super.initHttpHeaders(request);
                            this.setRequestHeader("Cookie", cookie);
                            this.setRequestHeader("X-CSRF-Token", token);
                        }
                    };
                }
            });
        }
        catch (BoaException e) {
            throw new LoginException(e.getMessage(), e);
        }
        catch (XmlRpcHttpTransportException e) {
            throw new LoginException("Invalid path given to Boa API.", e);
        }
        catch (XmlRpcException e) {
            if (e.getMessage().indexOf("Already logged in as ") == 0) {
                this.connect(username, password);
            }
            if (e.getMessage().indexOf("username") != -1) {
                throw new LoginException("Invalid username or password.", e);
            }
            if (e.getMessage().indexOf("response") != -1) {
                throw new LoginException("Invalid domain given to Boa API.", e);
            }
            if (e.getMessage().indexOf(":") != -1) {
                throw new LoginException(e.getMessage().substring(e.getMessage().indexOf(":") + 2), e);
            }
            throw new LoginException(e.getMessage(), e);
        }
        this.loggedIn = true;
    }

    protected void connect(String username, String password) throws LoginException {
        try {
            Map response = (Map)this.execute(Map.class, METHOD_SYSTEM_CONNECT, new String[]{username, password});
            final String cookie = (String)response.get("session_name") + "=" + (String)response.get("sessid");
            response = (Map)this.execute(Map.class, METHOD_USER_TOKEN, new Object[0]);
            final String token = (String)response.get("token");
            this.xmlRpcClient.setTransportFactory(new XmlRpcSunHttpTransportFactory(this.xmlRpcClient){

                @Override
                public XmlRpcTransport getTransport() {
                    return new XmlRpcSunHttpTransport(BoaClient.this.xmlRpcClient){

                        @Override
                        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
                            super.initHttpHeaders(request);
                            this.setRequestHeader("Cookie", cookie);
                            this.setRequestHeader("X-CSRF-Token", token);
                        }
                    };
                }
            });
        }
        catch (BoaException e) {
            throw new LoginException(e.getMessage(), e);
        }
        catch (XmlRpcHttpTransportException e) {
            throw new LoginException("Invalid path given to Boa API.", e);
        }
        catch (XmlRpcException e) {
            if (e.getMessage().indexOf("username") != -1) {
                throw new LoginException("Invalid username or password.", e);
            }
            if (e.getMessage().indexOf("response") != -1) {
                throw new LoginException("Invalid domain given to Boa API.", e);
            }
            if (e.getMessage().indexOf(":") != -1) {
                throw new LoginException(e.getMessage().substring(e.getMessage().indexOf(":") + 2), e);
            }
            throw new LoginException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws BoaException {
        block2: {
            this.resetDatasetCache();
            try {
                this.loggedIn = false;
                this.execute(METHOD_USER_LOGOUT, new Object[0]);
            }
            catch (XmlRpcException e) {
                if ("User is not logged in.".equals(e.getMessage())) break block2;
                throw new BoaException(e.getMessage(), e);
            }
        }
    }

    protected void ensureLoggedIn() throws NotLoggedInException {
        if (!this.loggedIn) {
            throw new NotLoggedInException();
        }
    }

    public void resetDatasetCache() {
        this.datasetCache = null;
        this.datasetCacheTime = 0L;
    }

    public List<InputHandle> getDatasets() throws BoaException, NotLoggedInException {
        if (this.datasetCache != null && this.datasetCacheTime + 86400000L > System.currentTimeMillis()) {
            return this.datasetCache;
        }
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.execute(METHOD_BOA_DATASETS, new Object[0]);
            this.datasetCache = new ArrayList<InputHandle>();
            for (int i = 0; i < result.length; ++i) {
                this.datasetCache.add(Util.parseDataset((Map)result[i]));
            }
            this.datasetCacheTime = System.currentTimeMillis();
            return this.datasetCache;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public String[] getDatasetNames() throws BoaException, NotLoggedInException {
        List<InputHandle> list = this.getDatasets();
        String[] items = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            items[i] = list.get(i).getName();
        }
        return items;
    }

    public InputHandle getDataset(String name) throws BoaException, NotLoggedInException {
        for (InputHandle h : this.getDatasets()) {
            if (!h.getName().equals(name)) continue;
            return h;
        }
        return null;
    }

    public JobHandle getJob(int id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.execute(Map.class, METHOD_BOA_JOB, new Object[]{id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle getLastJob() throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        List<JobHandle> jobs = this.getJobList(0, 1);
        if (jobs.isEmpty()) {
            return null;
        }
        return jobs.get(0);
    }

    public List<JobHandle> getJobList() throws BoaException, NotLoggedInException {
        return this.getJobList(false);
    }

    public List<JobHandle> getJobList(int offset, int length) throws BoaException, NotLoggedInException {
        return this.getJobList(false, offset, length);
    }

    public List<JobHandle> getJobList(boolean pubOnly) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.execute(METHOD_BOA_JOBS, new Object[]{pubOnly});
            ArrayList<JobHandle> jobs = new ArrayList<JobHandle>();
            for (int i = 0; i < result.length; ++i) {
                jobs.add(Util.parseJob(this, (Map)result[i]));
            }
            return jobs;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public List<JobHandle> getJobList(boolean pubOnly, int offset, int length) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.execute(METHOD_BOA_JOBS_RANGE, new Object[]{pubOnly, offset, length});
            ArrayList<JobHandle> jobs = new ArrayList<JobHandle>();
            for (int i = 0; i < result.length; ++i) {
                jobs.add(Util.parseJob(this, (Map)result[i]));
            }
            return jobs;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public int getJobCount() throws BoaException, NotLoggedInException {
        return this.getJobCount(false);
    }

    public int getJobCount(boolean pubOnly) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Integer.parseInt((String)this.execute(String.class, METHOD_BOA_JOBS_COUNT, new Object[]{pubOnly}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle query(String query, InputHandle dataset) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.execute(Map.class, METHOD_BOA_SUBMIT, new Object[]{query, dataset.getId()}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    public JobHandle query(String query) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Util.parseJob(this, (Map)this.execute(Map.class, METHOD_BOA_SUBMIT, new Object[]{query, this.getDatasets().get(0).getId()}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void stop(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.execute(METHOD_JOB_STOP, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void resubmit(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.execute(METHOD_JOB_RESUBMIT, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void delete(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.execute(METHOD_JOB_DELETE, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void setPublic(long id, boolean isPublic) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            this.execute(METHOD_JOB_SET_PUBLIC, new Object[]{"" + id, isPublic});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    boolean getPublic(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return (Integer)this.execute(Integer.class, METHOD_JOB_PUBLIC, new Object[]{"" + id}) == 1;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    URL getUrl(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return new URL((String)this.execute(String.class, METHOD_JOB_URL, new Object[]{"" + id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    URL getPublicUrl(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return new URL((String)this.execute(String.class, METHOD_JOB_PUBLIC_URL, new Object[]{"" + id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    List<String> getCompilerErrors(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            Object[] result = (Object[])this.execute(METHOD_JOB_COMPILER_ERRORS, new Object[]{"" + id});
            ArrayList<String> l = new ArrayList<String>();
            for (Object o : result) {
                l.add((String)o);
            }
            return l;
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    String getSource(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return (String)this.execute(String.class, METHOD_JOB_SOURCE, new Object[]{"" + id});
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    void getOutput(long id, File f) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            String url = (String)this.execute(String.class, METHOD_JOB_OUTPUT, new Object[]{"" + id});
            InputStream inStr = null;
            BufferedWriter writer = null;
            try {
                int cnt;
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                HttpURLConnection.setFollowRedirects(true);
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                inStr = conn.getInputStream();
                String encoding = conn.getContentEncoding();
                if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                    inStr = new GZIPInputStream(inStr);
                } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
                    inStr = new InflaterInputStream(inStr, new Inflater(true));
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(inStr));
                writer = new BufferedWriter(new FileWriter(f));
                char[] buf = new char[4096];
                while ((cnt = br.read(buf, 0, 4096)) > 0) {
                    writer.write(buf, 0, cnt);
                }
            }
            catch (MalformedURLException e) {
                throw new BoaException(url, e);
            }
            catch (IOException e) {
                throw new BoaException(e.getMessage(), e);
            }
            finally {
                try {
                    if (inStr != null) {
                        inStr.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getOutput(long id, long start, long len) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        StringBuffer sb = new StringBuffer();
        try {
            String url = (String)this.execute(String.class, METHOD_JOB_OUTPUT, new Object[]{"" + id});
            InputStream inStr = null;
            try {
                int cnt;
                HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
                HttpURLConnection.setFollowRedirects(true);
                if (len < 1L) {
                    conn.setRequestProperty("Range", "bytes=" + start + "-");
                } else {
                    conn.setRequestProperty("Range", "bytes=" + start + "-" + (start + len - 1L));
                }
                conn.connect();
                inStr = conn.getInputStream();
                String encoding = conn.getContentEncoding();
                if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                    inStr = new GZIPInputStream(inStr);
                } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
                    inStr = new InflaterInputStream(inStr, new Inflater(true));
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(inStr));
                char[] buf = new char[4096];
                while ((cnt = br.read(buf, 0, 4096)) > 0) {
                    sb.append(buf, 0, cnt);
                }
                String string = sb.toString();
                return string;
            }
            catch (MalformedURLException e) {
                throw new BoaException(url, e);
            }
            catch (IOException e) {
                throw new BoaException(e.getMessage(), e);
            }
            finally {
                try {
                    if (inStr != null) {
                        inStr.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }

    int getOutputSize(long id) throws BoaException, NotLoggedInException {
        this.ensureLoggedIn();
        try {
            return Integer.parseInt((String)this.execute(String.class, METHOD_JOB_OUTPUT_SIZE, new Object[]{"" + id}));
        }
        catch (XmlRpcException e) {
            throw new BoaException(e.getMessage(), e);
        }
    }
}

