/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.cs.boa;

import edu.iastate.cs.boa.BoaClient;
import edu.iastate.cs.boa.BoaException;
import edu.iastate.cs.boa.CompileStatus;
import edu.iastate.cs.boa.ExecutionStatus;
import edu.iastate.cs.boa.InputHandle;
import edu.iastate.cs.boa.JobHandle;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

final class Util {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    Util() {
    }

    static final JobHandle parseJob(BoaClient client, Map<?, ?> job) throws BoaException {
        Util.verifyKeys(job, "id", "submitted", "input", "compiler_status", "hadoop_status");
        return new JobHandle(client, Util.strToInt((String)job.get("id")), Util.strToDate((String)job.get("submitted")), Util.parseDataset((Map)job.get("input")), Util.strToCompileStatus((String)job.get("compiler_status")), Util.strToExecutionStatus((String)job.get("hadoop_status")));
    }

    static final InputHandle parseDataset(Map<?, ?> input) throws BoaException {
        Util.verifyKeys(input, "id", "name");
        return new InputHandle(Util.strToInt((String)input.get("id")), (String)input.get("name"));
    }

    private static void verifyKeys(Map<?, ?> m, String ... keys) throws BoaException {
        for (String k : keys) {
            if (m.containsKey(k)) continue;
            throw new BoaException("Invalid response from server: response does not contain key '" + k + "'.");
        }
    }

    private static Date strToDate(String s) throws BoaException {
        try {
            return df.parse(s);
        }
        catch (ParseException e) {
            throw new BoaException("Invalid date '" + s + "' from server.", e);
        }
    }

    private static int strToInt(String s) throws BoaException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new BoaException("Invalid number '" + s + "' from server.", e);
        }
    }

    private static CompileStatus strToCompileStatus(String s) throws BoaException {
        if ("Error".equals(s)) {
            return CompileStatus.ERROR;
        }
        if ("Finished".equals(s)) {
            return CompileStatus.FINISHED;
        }
        if ("Running".equals(s)) {
            return CompileStatus.RUNNING;
        }
        if ("Waiting".equals(s)) {
            return CompileStatus.WAITING;
        }
        throw new BoaException("Invalid response from server: compile_status '" + s + "' unknown");
    }

    private static ExecutionStatus strToExecutionStatus(String s) throws BoaException {
        if ("Error".equals(s)) {
            return ExecutionStatus.ERROR;
        }
        if ("Finished".equals(s)) {
            return ExecutionStatus.FINISHED;
        }
        if ("Running".equals(s)) {
            return ExecutionStatus.RUNNING;
        }
        if ("Waiting".equals(s)) {
            return ExecutionStatus.WAITING;
        }
        throw new BoaException("Invalid response from server: execution_status '" + s + "' unknown");
    }
}

