/*
 * Copyright 2013-2014 Iowa State University. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY IOWA STATE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL IOWA STATE UNIVERSITY OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of Iowa State University.
 */
import java.io.*;
import java.text.*;
import java.util.*;

/**
 * Generates Figure 8, Section 5.2.1.
 *
 * @author Robert Dyer (rdyer@iastate.edu)
 */
public class topgenerictypes {
	private static long rawtotal = 0;
	private static long total = 0;

	private final static List<String> rawnames = new ArrayList<>();
	private final static List<Long> rawvalues = new ArrayList<>();
	private final static List<String> names = new ArrayList<>();
	private final static List<Long> values = new ArrayList<>();

	private final static NumberFormat numFormat = NumberFormat.getInstance();

	public static void main(String[] args) throws IOException {
		getUses();

	    numFormat.setMaximumFractionDigits(2);

		System.out.println("% $Id: topgenerictypes.java,v 1.1 2013/09/15 19:49:50 rdyer Exp $");
		System.out.println("% DO NOT EDIT - This file automatically generated by section5-2/section5-2-1/topgenerics.java");
		System.out.println("\\begin{figure}[ht]");
		System.out.println("\\centering");
		System.out.println("\\rowcolors{2}{white}{gray!10}");
		System.out.println("\\begin{tabular}{|c|r|r|}");
		System.out.println("\\hline");
		System.out.println("\\textbf{Generic Type} & \\multicolumn{1}{c|}{\\textbf{Uses}} & \\textbf{Percent}\\\\");
		System.out.println("\\hline");
		for (int i = 0; i < rawnames.size(); i++)
			printRow(rawnames.get(i), rawvalues.get(i), rawtotal);
		System.out.println("\\hline");
		System.out.println("\\end{tabular}");

		System.out.println("\\rowcolors{2}{white}{gray!10}");
		System.out.println("\\begin{tabular}{|c|r|r|}");
		System.out.println("\\hline");
		System.out.println("\\textbf{Generic Type} & \\multicolumn{1}{c|}{\\textbf{Uses}} & \\textbf{Percent}\\\\");
		System.out.println("\\hline");
		for (int i = 0; i < names.size(); i++)
			printRow(names.get(i), values.get(i), total);
		System.out.println("\\hline");
		System.out.println("\\end{tabular}");

		System.out.println("\\caption{Variables declared with generic types.}");
		System.out.println("\\label{tab:generics}");
		System.out.println("\\end{figure}");
	}

	private static void printRow(String name, long value, long total) {
		System.out.print(name);
		System.out.print(" & " + numFormat.format(value));
	    numFormat.setMinimumFractionDigits(2);
		System.out.println(" & " + numFormat.format(100.0 * value / (double)total) + "\\% \\\\");
	    numFormat.setMinimumFractionDigits(0);
	}

	private static void getUses() throws IOException {
		final DataInputStream in = new DataInputStream(new FileInputStream("top-generic-types.txt"));
		final BufferedReader br = new BufferedReader(new InputStreamReader(in));

		String strLine;

		while ((strLine = br.readLine()) != null) {
			if (strLine.substring(0, strLine.indexOf(" = ")).equals("RawTypes[]")) {
				rawnames.add (strLine.substring(strLine.indexOf(" = ") + 3, strLine.lastIndexOf(", ")));
				long val = Long.parseLong(strLine.substring(strLine.lastIndexOf(", ") + 2));
				rawvalues.add (val);
				rawtotal += val;
			} else {
				names.add (strLine.substring(strLine.indexOf(" = ") + 3, strLine.lastIndexOf(", ")));
				long val = Long.parseLong(strLine.substring(strLine.lastIndexOf(", ") + 2));
				values.add (val);
				total += val;
			}
		}

		in.close();
	}
}
