/*
 * Copyright 2013-2014 Iowa State University. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY IOWA STATE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL IOWA STATE UNIVERSITY OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are those
 * of the authors and should not be interpreted as representing official policies,
 * either expressed or implied, of Iowa State University.
 */
import java.io.*;
import java.text.*;
import java.util.*;

/**
 * Generates Figure 15, Section 5.4.
 *
 * @author Robert Dyer (rdyer@iastate.edu)
 */
public class potentialuses {
	private static double files;
	private static double projects;

	private final static HashMap<String, Long> values = new HashMap<>();
	private final static NumberFormat numFormat = NumberFormat.getInstance();

	private static final String[] features = { "Assert", "Varargs", "BinaryLit", "Diamond", "MultiCatch", "TryResources", "Underscore" };

	public static void main(String[] args) throws IOException {
		getCounts();
		getUses();

	    numFormat.setMaximumFractionDigits(2);

		System.out.println("% $Id: potentialuses.java,v 1.2 2014/01/28 04:09:42 rdyer Exp $");
		System.out.println("% DO NOT EDIT - This file automatically generated by section5-4/potentialuses.java");
		System.out.println("\\begin{figure}[ht]");
		System.out.println("\\centering");
		System.out.println("\\newcolumntype{R}{%");
		System.out.println("    >{\\adjustbox{minipage=4.4em,angle=50,lap=0.5\\width}\\bgroup}%");
		System.out.println("    l%");
		System.out.println("    <{\\egroup}%");
		System.out.println("}");
		System.out.println("\\newcommand{\\oldtabcolsep}{\\tabcolsep}");
		System.out.println("\\renewcommand{\\tabcolsep}{1pt}");
		System.out.println("\\rowcolors{2}{white}{gray!10}");
		System.out.print("\\begin{tabular}{|c");
		for (int i = 0; i < features.length; i++)
			System.out.print("|r");
		System.out.println("|}");
		System.out.println("\\multicolumn{1}{c}{} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Assert}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Varargs}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Binary Literals}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Diamond}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{MultiCatch}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Try with Resources}} &");
		System.out.println("\\multicolumn{1}{R}{\\textbf{Underscore Literals}} \\\\");
		System.out.println("\\hline");
		printRow("Old");
		printRow("New");
		System.out.println("\\hline");
		System.out.println("\\hline");
		printRow("All");
		printRowPercent("Files", files);
		printRowPercent("Projects", projects);
		System.out.println("\\hline");
		System.out.println("\\end{tabular}");
		System.out.println("\\caption{Potential language feature uses, in old files (before feature");
		System.out.println("release) and new files (after feature release).}");
		System.out.println("\\label{tab:potential}");
		System.out.println("\\renewcommand{\\tabcolsep}{\\oldtabcolsep}");
		System.out.println("\\end{figure}");
	}

	private static void printRow(String name) {
		System.out.print("\\textbf{");
		System.out.print(name);
		System.out.print("}");
		for (String s : features)
			System.out.print(" & " + sizeformat(values.get(name + "Potential[" + s + "]")));
		System.out.println("\\\\");
	}

	private static String sizeformat(long val) {
		if (val > 700000) {
			numFormat.setMaximumFractionDigits(1);
			String s = numFormat.format(val / 1000000.0) + "M";
			numFormat.setMaximumFractionDigits(2);
			return s;
		}
		return Math.round(val / 1000.0) + "K";
	}

	private static void printRowPercent(String name, double total) {
		System.out.print("\\textbf{");
		System.out.print(name);
		System.out.print("}");
		for (String s : features)
			System.out.print(" & " + numFormat.format(100.0 * values.get(name + "Potential[" + s + "]") / total) + "\\%");
		System.out.println("\\\\");
	}

	private static void getCounts() throws IOException {
		final DataInputStream in = new DataInputStream(new FileInputStream("../section4-2/counts.txt"));
		final BufferedReader br = new BufferedReader(new InputStreamReader(in));

		String strLine;

		while ((strLine = br.readLine()) != null) {
			final String key = strLine.substring(0, strLine.indexOf("["));
			if (key.equals("JavaFiles"))
				files = Long.parseLong(strLine.substring(strLine.indexOf(" = ") + 3));
			else if (key.equals("StudiedProjects"))
				projects = Long.parseLong(strLine.substring(strLine.indexOf(" = ") + 3));
		}

		in.close();
	}

	private static void getUses() throws IOException {
		final DataInputStream in = new DataInputStream(new FileInputStream("potential-uses.txt"));
		final BufferedReader br = new BufferedReader(new InputStreamReader(in));

		String strLine;

		while ((strLine = br.readLine()) != null)
			values.put (strLine.substring(0, strLine.indexOf(" = ")), Long.parseLong(strLine.substring(strLine.indexOf(" = ") + 3)));

		in.close();
	}
}
